// object review
// m.miller 04.22.23

#version 3.8; 
global_settings {    
    max_trace_level 7
    ambient_light <.013,.01,.01> * 2                  
}                        

// --- S K Y  L I G H T
#declare light_zero =
light_source {
    <0,0,0> 
    #declare light_color = color red .05 green .05 blue .05 ;                      
    light_color * 5                  
    area_light
    <50, 0, 0> <0, 0, 50>         
    4, 4                          
    adaptive 0                    
    jitter                        
    circular                      
    orient                     
    fade_distance 300
    fade_power 2     
    translate <50,100,-200>
}   
light_zero



    
// -----------------------------------------------------------------------------------------
//                      S K Y
//------------------------------------------------------------------------------------------ 
background { rgb <0.12, 0.11, 0.1> * 10 } 
#include "sky.inc"
object { bg_sphere (<2000,2000,2000>, <0,100,0>, 250) scale <-1,1,1> }




// -----------------------------------------------------------------------------------------
//                      S C R E W S
//------------------------------------------------------------------------------------------ 
//  All below macros calls require a radius and a length ie: make_bolt_head(radius,length)
//  for screws, length is the screw head hieght, for bolts, it's the length of the bolt
//  the macro >> make_bolt(radius,length,treads) has a 3rd argument for treads.  0 = no threads 

#include "screws.inc" 
#declare M_metal = material {M_steel_aged scale <2,2,2>};
 

#declare screw_A = 
union{
    object { make_pan_head_flat(4,3) material{M_metal} }
    object { make_bolt(2,10,1)       material{M_metal} }
    rotate <0,40,0> 
    }
    
    
#declare screw_B = 
union{
    object { make_pan_head_phillips(4,3) material{M_metal} }
    object { make_bolt(2,20,1)           material{M_metal} }
    rotate <0,40,0>
    }  
    
#declare screw_C = 
union{    
    object { make_flat_head_phillips(2,1.5) material{M_metal} }
    object { make_bolt(2,30,1)              material{M_metal} }
    rotate <0,40,0>
    }
      
#declare bolt_A = 
union{      
    object { make_bolt_head(4,1.15) material{M_metal} }
    object { make_bolt(2,30,1)     material{M_metal} } 
    rotate <0,40,0>
    }
    

#declare bolt_B = 
union{      
    object { make_bolt_head(6,2.5) material{M_metal} }
    object { make_bolt(3,20,1)   material{M_metal} } 
    rotate <0,40,0>
    }
 

#declare bolt_C = 
union{      
    object { make_bolt_head(4,6) material{M_metal} }
    object { make_bolt(2,20,0)   material{M_metal} } 
    rotate <0,40,0>
    }
    
    
#declare nut = object { make_nut(4,1) material{M_metal} }



#declare loose_screws =
union {
    object { screw_A translate <-20,0,0> }  
    object { screw_B translate <-10,0,0>  }
    object { screw_C translate <0,0,0>   } 
    object { bolt_A  translate <10,0,0>   }   
    object { nut     translate <10,-10,0>   }
    object { bolt_B  translate <22,0,0>  } 
    object { bolt_C  translate <32,-3,0>  }
    }

object {loose_screws rotate <0,0,0> translate <0,0,0>}
object {loose_screws rotate <-65,0,0> translate <0,13,0>}

// -----------------------------------------------------------------------------------------
//                      C A M E R A 
//------------------------------------------------------------------------------------------ 
    camera {
        up <0, 1, 0>  
        angle 45    
        location <5,0,-80> 
        look_at <5,0,0>
    } 


 